﻿﻿#include <iostream>
#include <string>
#include <vector>
#include <string>
#include <algorithm>
#include <functional>
using namespace std;

const long long MOD = 1e9 + 7;

string toBin(string s) {
    string b;
    while (!s.empty() && s != "0") {
        int c = 0;
        string t;
        for (char x : s) {
            int cur = c * 10 + (x - '0');
            t.push_back((cur / 2) + '0');
            c = cur % 2;
        }
        b.push_back(c + '0');
        size_t p = 0;
        while (p < t.size() && t[p] == '0') p++;
        s = (p == t.size()) ? "" : t.substr(p);
    }
    if (b.empty()) return "0";
    reverse(b.begin(), b.end());
    return b;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    int n, K;
    string R;
    cin >> n >> K >> R;

    string br = toBin(R);
    int m = br.size();

    if (K > m) {
        cout << "1\n";
        return 0;
    }

    vector<vector<int>> dp(K, vector<int>(2));
    vector<vector<int>> ndp(K, vector<int>(2));

    dp[0][1] = 1;

    for (int p = 0; p < m; p++) {
        for (int c = 0; c < K; c++) {
            for (int t = 0; t < 2; t++) {
                if (!dp[c][t]) continue;
                int lim = t ? (br[p] - '0') : 1;
                for (int b = 0; b <= lim; b++) {
                    int nc = (c + b) % K;
                    int nt = t && (b == lim);
                    ndp[nc][nt] = (ndp[nc][nt] + dp[c][t]) % MOD;
                }
            }
        }
        swap(dp, ndp);
        for (int i = 0; i < K; i++)
            for (int j = 0; j < 2; j++)
                ndp[i][j] = 0;
    }

    cout << (dp[0][0] + dp[0][1]) % MOD << "\n";
    return 0;
}