﻿#include <iostream>
#include <string>
#include <vector>
#include <string>
#include <algorithm>
#include <functional>
using namespace std;

const long long MOD = 1e9 + 7;

string toBin(string s) {
    string b;
    while (!s.empty() && s != "0") {
        int c = 0;
        string t;
        for (char x : s) {
            int cur = c * 10 + (x - '0');
            t.push_back((cur / 2) + '0');
            c = cur % 2;
        }
        b.push_back(c + '0');
        size_t p = 0;
        while (p < t.size() && t[p] == '0') p++;
        s = (p == t.size()) ? "" : t.substr(p);
    }
    if (b.empty()) return "0";
    reverse(b.begin(), b.end());
    return b;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    int n, K;
    string R;
    cin >> n >> K >> R;

    string br = toBin(R);
    int m = br.size();

    if (K > m) {
        cout << "1\n";
        return 0;
    }

    vector<vector<vector<long long>>> dp(m + 1,
        vector<vector<long long>>(K,
            vector<long long>(2, -1)));

    function<long long(int, int, int)> f = [&](int p, int c, int t) -> long long {
        if (p == m) return c == 0;
        if (dp[p][c][t] != -1) return dp[p][c][t];
        long long r = 0;
        int lim = t ? (br[p] - '0') : 1;
        for (int b = 0; b <= lim; b++)
            r = (r + f(p + 1, (c + b) % K, t && (b == lim))) % MOD;
        dp[p][c][t] = r;
        return r;
        };

    cout << f(0, 0, 1) << "\n";
    return 0;
}