﻿
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
using namespace std;

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    int m;
    long long l, r;
    cin >> m;
    cin >> l >> r;

    int N = (int)r;
    if (N < 2) {
        cout << -1 << "\n";
        return 0;
    }

    vector<int> spf(N + 1, 0);
    for (int i = 2; i <= N; ++i) {
        if (spf[i] == 0) {
            spf[i] = i;
            if ((long long)i * i <= N) {
                for (long long j = 1LL * i * i; j <= N; j += i) {
                    if (spf[(int)j] == 0) spf[(int)j] = i;
                }
            }
        }
    }

    vector<char> good(N + 1, 0);
    for (int n = 2; n <= N; ++n) {
        int x = n;
        bool ok = true;
        while (x > 1) {
            int p = spf[x];
            int cnt = 0;
            while (x % p == 0) {
                x /= p;
                ++cnt;
            }
            if ((cnt & 1) == 0) {
                ok = false;
                break;
            }
        }
        good[n] = ok ? 1 : 0;
    }

    long long len = r - l + 1;
    if (len < m) {
        cout << -1 << "\n";
        return 0;
    }

    int consec = 0;
    long long start = -1;
    for (long long i = l; i <= r; ++i) {
        if (good[(int)i]) {
            ++consec;
            if (consec >= m) {
                start = i - m + 1;
                break;
            }
        }
        else {
            consec = 0;
        }
    }

    if (start == -1) {
        cout << -1 << "\n";
    }
    else {
        for (int t = 0; t < m; ++t) {
            if (t) cout << ' ';
            cout << (start + t);
        }
        cout << "\n";
    }

    return 0;
}
