import math

def gcd(a, b):
    while b:
        a, b = b, a % b
    return abs(a)

def norm(dx, dy):
    if dx == 0 and dy == 0:
        return (0, 0)
    if dx == 0:
        return (0, 1 if dy > 0 else -1)
    if dy == 0:
        return (1 if dx > 0 else -1, 0)
    g = gcd(abs(dx), abs(dy))
    dx //= g
    dy //= g
    if dx < 0 or (dx == 0 and dy < 0):
        dx, dy = -dx, -dy
    return (dx, dy)

T = int(input())
out = []

for _ in range(T):
    n = int(input())
    rects = [tuple(map(int, input().split())) for _ in range(n)]
    
    corners = []
    for x1, y1, x2, y2 in rects:
        corners.append((x1, y1))
        corners.append((x1, y2))
        corners.append((x2, y1))
        corners.append((x2, y2))
    
    ok = False
    
    directions = set()
    directions.add((1, 0))
    directions.add((0, 1))
    
    for i in range(len(corners)):
        for j in range(i + 1, len(corners)):
            x1, y1 = corners[i]
            x2, y2 = corners[j]
            dx, dy = x2 - x1, y2 - y1
            if dx == 0 and dy == 0:
                continue
            dir_norm = norm(dx, dy)
            directions.add(dir_norm)
            directions.add(norm(-dx, -dy))
    
    for dx, dy in directions:
        if dx == 0 and dy == 0:
            continue
        
        low = -10**30
        high = 10**30
        
        val = True
        for x1, y1, x2, y2 in rects:
            proj = [
                dx * x1 + dy * y1,
                dx * x1 + dy * y2,
                dx * x2 + dy * y1,
                dx * x2 + dy * y2
            ]
            mini = min(proj)
            maxi = max(proj)
            
            low = max(low, mini)
            high = min(high, maxi)
            
            if low > high:
                val = False
                break
        
        if val and low <= high:
            ok = True
            break
    
    out.append("Yes" if ok else "No")

print("\n".join(out))