import math


def sito(n: int):
    spf = list(range(n + 1))
    i = 2
    while i * i <= n:
        if spf[i] == i:
            for j in range(i * i, n + 1, i):
                if spf[j] == j:
                    spf[j] = i
        i += 1
    return spf


m = int(input())
l, r = map(int, input().split())

length = r - l + 1
if m > length:
    print(-1)
else:
    spf = sito(r)
    
    rad = [0] * (r + 1)
    rad[1] = 1
    
    for n in range(2, r + 1):
        p = spf[n]
        t = n // p
        if t % p == 0:
            rad[n] = rad[t]
        else:
            rad[n] = rad[t] * p
    
    good_all = [False] * (r + 1)
    for n in range(2, r + 1):
        q = n // rad[n]
        s = math.isqrt(q)
        if s * s == q:
            good_all[n] = True
    
    good = [False] * length
    for i in range(length):
        num = l + i
        good[i] = good_all[num]
    
    pref = [0] * (length + 1)
    for i in range(length):
        pref[i + 1] = pref[i] + (1 if good[i] else 0)
    
    for start in range(length - m + 1):
        if pref[start + m] - pref[start] == m:
            first = l + start
            result = [first + i for i in range(m)]
            print(*result)
            break
    else:
        print(-1)