def sito(n: int):
    spf = list(range(n + 1))
    i = 2
    while i * i <= n:
        if spf[i] == i:
            start = i * i
            step = i
            for j in range(start, n + 1, step):
                if spf[j] == j:
                    spf[j] = i
        i += 1
    return spf


def brito(num: int, spf) -> bool:
    while num > 1:
        p = spf[num]
        cnt = 0
        while num % p == 0:
            num //= p
            cnt ^= 1
        if cnt == 0:
            return False
    return True


m = int(input())
l, r = map(int, input().split())

length = r - l + 1
if m > length:
    print(-1)
else:
    spf = sito(r)

    good = [0] * length
    val = l
    for i in range(length):
        if brito(val, spf):
            good[i] = 1
        val += 1

    pref = [0] * (length + 1)
    for i in range(length):
        pref[i + 1] = pref[i] + good[i]

    for start in range(length - m + 1):
        if pref[start + m] - pref[start] == m:
            first = l + start
            print(*[first + i for i in range(m)])
            break
    else:
        print(-1)