import sys

def solve():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())
    MAX_R = 10 ** 6
    lp = [0] * (MAX_R + 1)
    primes = []
    for i in range(2, MAX_R + 1):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
        for p in primes:
            if p > lp[i] or i * p > MAX_R:
                break
            lp[i * p] = p
    is_odd_powered_arr = [False] * (MAX_R + 1)
    is_odd_powered_arr[1] = True
    for i in range(2, MAX_R + 1):
        temp_num = i
        current_is_odd = True
        while temp_num > 1:
            prime_factor = lp[temp_num]
            count = 0
            while temp_num % prime_factor == 0:
                count += 1
                temp_num //= prime_factor
            if count % 2 == 0:
                current_is_odd = False
                break
        is_odd_powered_arr[i] = current_is_odd
    current_valid_count = 0
    for i in range(l, l + m):
        if i > r:
            print("-1")
            return
        if is_odd_powered_arr[i]:
            current_valid_count += 1

    if current_valid_count == m:
        print(*(range(l, l + m)))
        return
    for start_val in range(l + 1, r - m + 2):
        if is_odd_powered_arr[start_val - 1]:
            current_valid_count -= 1

        if is_odd_powered_arr[start_val + m - 1]:
            current_valid_count += 1

        if current_valid_count == m:
            print(*(range(start_val, start_val + m)))
            return
    print("-1")

solve()
