import sys

m = int(sys.stdin.readline())
l, r = map(int, sys.stdin.readline().split())

MAX_N = 10**6
is_prime = [True]*(MAX_N+1)
is_prime[0] = False
is_prime[1] = False
for i in range(2, int(MAX_N**0.5)+1):
    if is_prime[i]:
        for j in range(i*i, MAX_N+1, i):
            is_prime[j] = False
primes = [i for i in range(2, MAX_N+1) if is_prime[i]]
square_free = [True]*(r+1)

for p in primes:
    p2 = p*p
    for multiple in range(((l + p2 - 1)//p2)*p2, r+1, p2):
        square_free[multiple] = False

count = 0
start_index = -1
for num in range(l, r+1):
    if square_free[num]:
        count += 1
        if count == m:
            start_index = num - m + 1
            break
    else:
        count = 0

if start_index == -1:
    print(-1)
else:
    print(' '.join(str(i) for i in range(start_index, start_index + m)))