MOD = 10**9 + 7

def solve():
    import sys
    n, K = map(int, sys.stdin.readline().split())
    R_str = sys.stdin.readline().strip()

    # Преобразуем R в двоичную строку без ведущих нулей
    R_bin = bin(int(R_str))[2:]
    L = len(R_bin)

    # Инициализация DP
    dp_old = [[0] * 2 for _ in range(K)]  # Состояния для предыдущего бита
    dp_old[0][1] = 1  # Начинаем с пустого префикса, строго равны

    # Обрабатываем каждый бит
    for i in range(L):
        bit_R = int(R_bin[i])

        # Новый массив для текущего бита
        dp_new = [[0] * 2 for _ in range(K)]

        # Обновляем dp_new на основе dp_old
        for rem in range(K):
            for tight in range(2):
                if dp_old[rem][tight] == 0:
                    continue

                # Пробуем поставить 0 и 1
                for d in (0, 1):
                    if tight and d > bit_R:
                        continue  # Нельзя превысить R
                    new_tight = 1 if (tight and d == bit_R) else 0
                    new_rem = (rem + d) % K
                    dp_new[new_rem][new_tight] = (dp_new[new_rem][new_tight] + dp_old[rem][tight]) % MOD

        # Обновляем dp_old на следующий шаг
        dp_old = dp_new

    # Ответ - сумма по остаткам K=0 для обоих вариантов tight
    ans = (dp_old[0][0] + dp_old[0][1]) % MOD
    print(ans)

solve()
