MOD = 10**9 + 7

def solve():
   import sys
   n, K = map(int, sys.stdin.readline().split())
   R_str = sys.stdin.readline().strip()

   # Преобразуем R в двоичную строку без ведущих нулей
   R_bin = bin(int(R_str))[2:]  # получаем двоичную строку
   L = len(R_bin)

   # dp[i][rem][tight], где i - индекс в R_bin, rem - остаток по K, tight - равенство с R
   dp = [[[0] * 2 for _ in range(K)] for _ in range(L + 1)]
   dp[0][0][1] = 1  # Начинаем с пустого префикса, строго равны

   for i in range(L):
       bit_R = int(R_bin[i])

       for rem in range(K):
           for tight in range(2):
               if dp[i][rem][tight] == 0:
                   continue

               # Пробуем поставить 0 и 1
               for d in (0, 1):
                   if tight and d > bit_R:
                       continue  # нельзя превысить R
                   new_tight = 1 if (tight and d == bit_R) else 0
                   new_rem = (rem + d) % K
                   dp[i+1][new_rem][new_tight] = (
                       dp[i+1][new_rem][new_tight] + dp[i][rem][tight]
                   ) % MOD

   # Ответ - сумма по остаткам K=0 для обоих вариантов tight
   ans = (dp[L][0][0] + dp[L][0][1]) % MOD
   print(ans)

solve()
