import math

def count_occurrences(start, end, k, remainder):
    """
    Подсчитывает, сколько чисел в диапазоне [start, end] (включительно)
    имеют определенный остаток (remainder) при делении на k.
    """
    if start > end:
        return 0

    # Находим первое число в диапазоне >= start, которое имеет нужный остаток
    # (remainder - start % k + k) % k гарантирует, что мы получим корректный сдвиг
    # даже если remainder < start % k
    first_val_in_range = start + (remainder - start % k + k) % k

    if first_val_in_range > end:
        return 0

    # Все последующие числа, соответствующие остатку, будут first_val_in_range + k, first_val_in_range + 2k, ...
    # Количество таких чисел: (последнее_число - первое_число) / k + 1
    return (end - first_val_in_range) // k + 1

def sum_arithmetic_series(first_term, num_terms, common_diff):
    """
    Вычисляет сумму арифметической прогрессии.
    Формула: Sum = num_terms * (first_term + last_term) / 2
    last_term = first_term + (num_terms - 1) * common_diff
    """
    if num_terms == 0:
        return 0
    
    last_term = first_term + (num_terms - 1) * common_diff
    return num_terms * (first_term + last_term) // 2

n = int(input())
m = int(input())
k = int(input())

counts = [0] * k

min_dim = min(n, m)
max_dim = max(n, m)

# Фаза 1: Диагонали с возрастающей длиной (от 1 до min_dim)
# Значение s изменяется от 0 до min_dim - 1
# Длина диагонали s равна (s + 1)
start_s_phase1 = 0
end_s_phase1 = min_dim - 1

if start_s_phase1 <= end_s_phase1: # Проверяем, существует ли эта фаза
    for j in range(k): # Итерируем по каждому цвету
        # Считаем, сколько значений s в диапазоне [start_s_phase1, end_s_phase1] имеют s % k == j
        num_s_for_j = count_occurrences(start_s_phase1, end_s_phase1, k, j)
        
        if num_s_for_j > 0:
            # Первое значение s для этого цвета j в этой фазе (это просто j, так как start_s_phase1 = 0)
            first_s_val_for_j = j
            
            # Длина диагонали, соответствующая этому первому s_val
            first_len = first_s_val_for_j + 1
            
            # Длины диагоналей для данного цвета j образуют арифметическую прогрессию
            # с разностью k (например, для цвета 0: длины 1, k+1, 2k+1, ...)
            counts[j] += sum_arithmetic_series(first_len, num_s_for_j, k)

# Фаза 2: Диагонали с постоянной длиной (min_dim)
# Значение s изменяется от min_dim до max_dim - 1
# Длина диагонали s всегда равна min_dim
start_s_phase2 = min_dim
end_s_phase2 = max_dim - 1

if start_s_phase2 <= end_s_phase2: # Проверяем, существует ли эта фаза
    for j in range(k): # Итерируем по каждому цвету
        num_s_for_j = count_occurrences(start_s_phase2, end_s_phase2, k, j)
        counts[j] += num_s_for_j * min_dim # Все диагонали имеют одинаковую длину

# Фаза 3: Диагонали с убывающей длиной (от min_dim - 1 до 1)
# Значение s изменяется от max_dim до n + m - 2 (последнее значение s)
# Длина диагонали s равна (n + m - 1 - s)
start_s_phase3 = max_dim
end_s_phase3 = n + m - 2

if start_s_phase3 <= end_s_phase3: # Проверяем, существует ли эта фаза
    for j in range(k): # Итерируем по каждому цвету
        num_s_for_j = count_occurrences(start_s_phase3, end_s_phase3, k, j)
        
        if num_s_for_j > 0:
            # Первое значение s для этого цвета j в этой фазе
            first_s_val_for_j = start_s_phase3 + (j - start_s_phase3 % k + k) % k
            
            # Длина диагонали, соответствующая этому первому s_val
            first_len = n + m - 1 - first_s_val_for_j
            
            # Длины диагоналей для данного цвета j образуют арифметическую прогрессию
            # с разностью -k (например, для цвета 0: длины L, L-k, L-2k, ...)
            counts[j] += sum_arithmetic_series(first_len, num_s_for_j, -k)

# Вывод результата
for c in counts:
    print(c)

