import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    R = int(R_str)
    
    # Обработка R = 0
    if R == 0:
        print(1)
        return
    
    # Двоичное представление R
    bits = bin(R)[2:]
    L = len(bits)
    
    # Если K > L, единственное подходящее число — 0
    if K > L:
        print(1)
        return
    
    # Для небольших K (<= 100) используем предподсчёт S(len, r)
    if K <= 100:
        # S[len][r] = сумма C(len, i) для i ≡ r (mod K)
        S = [[0] * K for _ in range(L + 1)]
        S[0][0] = 1
        for length in range(1, L + 1):
            for r in range(K):
                S[length][r] = (S[length-1][r] + S[length-1][(r-1) % K]) % MOD
        
        ans = 0
        cnt = 0  # количество единиц на совпадающем префиксе
        for i, b in enumerate(bits):
            rest = L - i - 1
            if b == '1':
                # Вариант: на текущем бите ставим 0, дальше произвольно
                r_needed = (-cnt) % K
                ans = (ans + S[rest][r_needed]) % MOD
                # Продолжаем с битом 1
                cnt += 1
        # Учитываем само число R
        if cnt % K == 0:
            ans = (ans + 1) % MOD
        print(ans)
        return
    
    # Для K > 100 используем цифровую DP с двумя состояниями флага
    dp0 = [0] * K  # флаг 0: префикс точно совпадает с R
    dp1 = [0] * K  # флаг 1: префикс уже меньше R
    dp0[0] = 1
    
    for b in bits:
        ndp0 = [0] * K
        ndp1 = [0] * K
        bit_val = int(b)
        for r in range(K):
            val0 = dp0[r]
            val1 = dp1[r]
            if val0 == 0 and val1 == 0:
                continue
            if val0:
                if bit_val == 1:
                    # Ставим 0 -> переход в флаг 1, остаток не меняется
                    ndp1[r] = (ndp1[r] + val0) % MOD
                    # Ставим 1 -> остаёмся в флаге 0, остаток увеличивается
                    ndp0[(r + 1) % K] = (ndp0[(r + 1) % K] + val0) % MOD
                else:
                    # bit_val == 0, можно поставить только 0
                    ndp0[r] = (ndp0[r] + val0) % MOD
            if val1:
                # Уже меньше, можно ставить 0 или 1
                ndp1[r] = (ndp1[r] + val1) % MOD
                ndp1[(r + 1) % K] = (ndp1[(r + 1) % K] + val1) % MOD
        dp0, dp1 = ndp0, ndp1
    
    ans = (dp0[0] + dp1[0]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()