import sys

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    # ---------- 1. Решето для нахождения наименьшего простого делителя ----------
    N = r
    spf = [0] * (N + 1)
    primes = []
    for i in range(2, N + 1):
        if spf[i] == 0:
            spf[i] = i
            primes.append(i)
        for p in primes:
            if p > spf[i] or i * p > N:
                break
            spf[i * p] = p
    
    # ---------- 2. Определение, является ли число нечётно-степенным ----------
    is_odd = [False] * (N + 1)
    is_odd[1] = True   # для корректной рекурсии
    for n in range(2, N + 1):
        p = spf[n]
        cnt = 0
        temp = n
        while temp % p == 0:
            temp //= p
            cnt += 1
        # если степень p нечётная и оставшаяся часть тоже нечётно-степенная
        is_odd[n] = (cnt % 2 == 1) and is_odd[temp]
    
    # ---------- 3. Поиск последовательности из m подряд идущих чисел ----------
    start = -1
    cur_len = 0
    for x in range(l, r + 1):
        if is_odd[x]:
            cur_len += 1
            if cur_len == m:
                start = x - m + 1
                break
        else:
            cur_len = 0
    
    # ---------- 4. Вывод результата ----------
    if start == -1:
        print(-1)
    else:
        print(' '.join(str(start + i) for i in range(m)))

if __name__ == "__main__":
    main()