import sys

def main():
    n, m, k = map(int, sys.stdin.read().strip().split())
    
    # Количество строк с остатком a = (i-1) % k
    cnt_i = [n // k + (1 if r < n % k else 0) for r in range(k)]
    # Количество столбцов с остатком b = (j-1) % k  
    cnt_j = [m // k + (1 if r < m % k else 0) for r in range(k)]
    
    results = []
    for color in range(1, k + 1):
        total = 0
        # Цвет соответствует остатку (color-1)
        target = color - 1
        for a in range(k):
            # Нужно: (a + b) % k == target
            b = (target - a) % k
            total += cnt_i[a] * cnt_j[b]
        results.append(str(total))
    
    sys.stdout.write("\n".join(results))

if __name__ == "__main__":
    main()