#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/hash_policy.hpp>

#pragma GCC optimize("Ofast")
#pragma GCC optimize("fast-math")

using namespace std;
using ll = long long;

#define pll pair<ll, ll>
#define vll vector<ll>

const ll MOD = 1e9 + 7;
const ll INF = 1e18;
const ll LOG = 30;
const ll N = 1e6 + 10;

ll gcd(ll a, ll b) {
    if (!b) return a;
    return gcd(b, a % b);
}

ll binpow(ll a, ll b) {
    if (!b) return 1;
    if (b % 2 == 1) return (a * binpow(a, b - 1)) % MOD;
    ll x = binpow(a, b / 2);
    return x * x % MOD;
}

pair<string, int> f(string s) {
    string ans = "";
    int tec = 0;
    int ss = s.size();
    for (int i = 0; i < ss; ++i) {
        tec = tec * 10 + ll(s[i] - '0');
        if (tec < 2) {
            ans += '0';
            continue;
        }
        ans += to_string(tec / 2);
        tec = tec % 2;
    }
    ll pos = 0;
    while (pos < ss && ans[pos] == '0') pos++;
    if (pos == ss) return {"0", 1};
    string res = "";
    for (ll i = pos; i < ss; ++i) res += ans[i];
    return {res, tec};
}

vector<ll> fact;

ll C(ll n, ll k) {
    if (k > n) return 0;
    if (k == 0) return 1;
    if (k == n) return 1;
    ll a = fact[n];
    ll b = fact[k] * fact[n - k] % MOD;
    return a * binpow(b, MOD - 2) % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    fact.resize(N);
    fact[0] = 1;
    for (int i = 1; i < N; ++i) fact[i] = (fact[i - 1] * i) % MOD;

    ll n, k; cin >> n >> k;
    string t; cin >> t;
    string s = "";
    while (t != "0") {
        pair<string, ll> res = f(t);
        s += to_string(res.second);
        t = res.first;
    }
    if (s.size() == 0) {
        cout << 1 << '\n';
        return 0;
    }
    reverse(s.begin(), s.end());
    n = s.size();

    ll ans = 0;
    ll c = 0;
    for (char v : s) c += ll(v - '0');
    if (c % k == 0) ans = 1;
    for (int j = 0; j <= (n + k - 1) / k + 1; ++j) {
        ll k1 = k * j;
        ans = (ans + C(n - 1, k1)) % MOD;
        int cnt = 0;
        for (ll i = 1; i < s.size(); ++i) {
            if (s[i] == '0') continue;
            cnt++;
            if (cnt > k1) break;
            ans = (ans + C(n - i - 1, k1 - ll(cnt))) % MOD;
        }
    }
    cout << ans << '\n';
}