import sys

def solve():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    it = iter(input_data)
    T = int(next(it))
    out_lines = []
    
    for _ in range(T):
        n = int(next(it))
        rects = []
        min_x = min_y = float('inf')
        max_x = max_y = float('-inf')
        for __ in range(n):
            x1 = int(next(it)); y1 = int(next(it))
            x2 = int(next(it)); y2 = int(next(it))
            rects.append((x1, y1, x2, y2))
            min_x = min(min_x, x1, x2)
            max_x = max(max_x, x1, x2)
            min_y = min(min_y, y1, y2)
            max_y = max(max_y, y1, y2)
        
        possible = False
        
        y_low = max(r[1] for r in rects)
        y_high = min(r[3] for r in rects)
        if y_low <= y_high:
            possible = True
   
        x_low = max(r[0] for r in rects)
        x_high = min(r[2] for r in rects)
        if x_low <= x_high:
            possible = True
  
        if possible:
            out_lines.append("Yes")
            continue       
  
        min_b_45 = float('-inf')
        max_b_45 = float('inf')
        for x1, y1, x2, y2 in rects:
            vals = [y1 - x2, y1 - x1, y2 - x2, y2 - x1]
            low = min(vals)
            high = max(vals)
            min_b_45 = max(min_b_45, low)
            max_b_45 = min(max_b_45, high)
        if min_b_45 <= max_b_45:
            possible = True

        min_b_135 = float('-inf')
        max_b_135 = float('inf')
        for x1, y1, x2, y2 in rects:
            vals = [x1 + y1, x1 + y2, x2 + y1, x2 + y2]
            low = min(vals)
            high = max(vals)
            min_b_135 = max(min_b_135, low)
            max_b_135 = min(max_b_135, high)
        if min_b_135 <= max_b_135:
            possible = True
    
        if possible:
            out_lines.append("Yes")
        else:
            out_lines.append("No")
    
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()
