import sys

MOD = 10**9 + 7

def main():
    # Ввод данных
    line1 = input().strip()
    if not line1:
        return
    n, K = map(int, line1.split())
    R = input().strip()
    
    # Двоичное представление R
    bin_R = bin(int(R))[2:]
    L = len(bin_R)
    
    # DP: dp[ones_mod][less]
    dp = [[0, 0] for _ in range(K)]
    dp[0][0] = 1
    
    for pos in range(L):
        bit_R = 1 if bin_R[pos] == '1' else 0
        new_dp = [[0, 0] for _ in range(K)]
        
        for ones in range(K):
            for less in range(2):
                cur = dp[ones][less]
                if cur == 0:
                    continue
                # Ставим 0
                new_less = less or (bit_R > 0)
                new_dp[ones][new_less] = (new_dp[ones][new_less] + cur) % MOD
                # Ставим 1
                if less or bit_R == 1:
                    new_ones = (ones + 1) % K
                    new_dp[new_ones][less] = (new_dp[new_ones][less] + cur) % MOD
        dp = new_dp
    
    result = (dp[0][0] + dp[0][1]) % MOD
    print(result)

if __name__ == "__main__":
    main()
