MOD = 10**9 + 7

def solve():
    import sys
    
    # Чтение первой строки: n и K
    line1 = sys.stdin.readline().strip()
    if not line1:
        return
    n, K = map(int, line1.split())
    
    # Чтение второй строки: число R
    R = sys.stdin.readline().strip()
    
    # Переводим R в двоичное
    bin_R = bin(int(R))[2:]
    L = len(bin_R)
    
    # dp[pos][ones_mod][less]
    dp = [[[0, 0] for _ in range(K)] for _ in range(L + 1)]
    dp[0][0][0] = 1
    
    for pos in range(L):
        bit_R = int(bin_R[pos])
        for ones in range(K):
            for less in range(2):
                cur = dp[pos][ones][less]
                if cur == 0:
                    continue
                # Ставим 0
                new_less = less or (bit_R > 0)
                dp[pos + 1][ones][new_less] = (dp[pos + 1][ones][new_less] + cur) % MOD
                # Ставим 1
                if less or bit_R == 1:
                    new_ones = (ones + 1) % K
                    dp[pos + 1][new_ones][less] = (dp[pos + 1][new_ones][less] + cur) % MOD
    
    result = (dp[L][0][0] + dp[L][0][1]) % MOD
    print(result)

if __name__ == "__main__":
    solve()
