def solve():
    import sys
    input = sys.stdin.readline
    
    m = int(input().strip())
    t, r = map(int, input().split())
    
    # Массив: lpf[i] = наименьший простой делитель i
    lpf = [0] * (r + 1)
    primes = []
    for i in range(2, r + 1):
        if lpf[i] == 0:
            lpf[i] = i
            primes.append(i)
        for p in primes:
            if p > lpf[i] or i * p > r:
                break
            lpf[i * p] = p
    
    # Проверка: является ли число нечётно-степенным
    def is_odd_power(num):
        last = 0
        cnt = 0
        while num > 1:
            p = lpf[num]
            if p != last:
                if last != 0 and cnt % 2 == 0:
                    return False
                last = p
                cnt = 0
            cnt += 1
            num //= p
        if cnt % 2 == 0:
            return False
        return True
    
    # Заранее вычислим для всех чисел
    good = [False] * (r + 1)
    for i in range(t, r + 1):
        if is_odd_power(i):
            good[i] = True
    
    # Поиск m подряд идущих
    found_start = -1
    consecutive = 0
    for num in range(t, r + 1):
        if good[num]:
            consecutive += 1
            if consecutive == m:
                found_start = num - m + 1
                break
        else:
            consecutive = 0
    
    if found_start == -1:
        print(-1)
    else:
        print(' '.join(str(i) for i in range(found_start, found_start + m)))

if __name__ == "__main__":
    solve()
