def solve():
    import sys
    input = sys.stdin.readline
    
    m = int(input().strip())
    t, r = map(int, input().split())
    
    # is_odd_power[i] = True, если i — нечётно-степенное
    is_odd_power = [True] * (r + 1)
    is_odd_power[0] = is_odd_power[1] = False  # 0 и 1 не натуральные в контексте задачи
    
    # Решето: помечаем числа, делящиеся на квадрат простого
    for p in range(2, int(r**0.5) + 1):
        p2 = p * p
        for multiple in range(p2, r + 1, p2):
            is_odd_power[multiple] = False
    
    # Теперь ищем m подряд идущих True в диапазоне [t, r]
    found_start = -1
    consecutive = 0
    
    for num in range(t, r + 1):
        if is_odd_power[num]:
            consecutive += 1
            if consecutive == m:
                found_start = num - m + 1
                break
        else:
            consecutive = 0
    
    if found_start == -1:
        print(-1)
    else:
        print(' '.join(str(i) for i in range(found_start, found_start + m)))

if __name__ == "__main__":
    solve()
