def count_magic(x):
    """Количество магических чисел от 1 до x включительно"""
    return (x // 7) + ((x + 3) // 10) - ((x + 63) // 70)

def find_kth_magic(k):
    """Бинарный поиск k-го магического числа"""
    left, right = 1, 10**18  # правая граница заведомо больше ответа
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
    return left

def solve():
    k = int(input().strip())
    print(find_kth_magic(k))

if __name__ == "__main__":
    solve()
