import math

def main():
    m = int(input())
    l, r = map(int, input().split())

    if m > r - l + 1:
        print(-1)
        return

    is_prime = [True] * (r + 1)
    is_prime[0] = is_prime[1] = False
    primes = []
    for i in range(2, r + 1):
        if is_prime[i]:
            primes.append(i)
            if i * i <= r:
                for j in range(i * i, r + 1, i):
                    is_prime[j] = False

    a = [1] * (r + 1)
    for p in primes:
        for multiple in range(p, r + 1, p):
            a[multiple] *= p

    good = [False] * (r + 1)
    for n in range(1, r + 1):
        q = n // a[n]
        s = int(math.isqrt(q))
        if s * s == q:
            good[n] = True

    cnt = 0
    start = -1
    for i in range(l, r + 1):
        if good[i]:
            cnt += 1
            if cnt == m:
                start = i - m + 1
                break
        else:
            cnt = 0

    if start == -1:
        print(-1)
    else:
        print(' '.join(str(i) for i in range(start, start + m)))

if __name__ == "__main__":
    main()