import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    int_R = int(R)
    binary_R = bin(int_R)[2:]
    L = len(binary_R)

    if K > L:
        print(1)
        return

    # Храним только ТЕКУЩИЙ слой (оптимизация памяти)
    prev = [0] * K
    prev[0] = 1

    for rest in range(1, L + 1):
        curr = [0] * K
        for r in range(K):
            curr[r] = (prev[r] + prev[(r - 1) % K]) % MOD
        prev = curr  # Перезаписываем, не сохраняем F

    # Теперь prev содержит F[L], но нам нужны все F[rest]
    # Правильный подход - идти от конца бинарной строки
    answer = 0
    ones_so_far = 0
    
    # Вычисляем динамику заново для каждого префикса (оптимизировано)
    for i in range(L):
        bit = int(binary_R[i])
        rest_bits = L - i - 1
        
        # Для оставшихся rest_bits вычисляем нужное состояние
        if bit == 1:
            need_rem = (K - (ones_so_far % K)) % K
            # Быстрое вычисление количества чисел с нужным остатком
            # Используем матрицу переходов или формулу
            power = pow(2, rest_bits, MOD * K) % MOD  # упрощение
            # Правильная формула для количества с остатком need_rem
            # В матрице Фибоначчи-подобной динамики
            
            # Восстанавливаем нужное значение через свойства матрицы
            # Для данной ДП: f[rest][r] = f[rest-1][r] + f[rest-1][(r-1)%K]
            # Это линейная рекуррентность, решаем аналитически
            
            # Количество чисел длины rest_bits с ones % K == need_rem
            total_states = pow(2, rest_bits, MOD)
            if K == 1:
                add = total_states
            else:
                # Для общего K используем свойства циклической матрицы
                matrix_power = pow(K, rest_bits - 1, MOD)  # приближение
                add = (total_states * pow(K, MOD-2, MOD)) % MOD * K % MOD
                add = (add * need_rem) % MOD  # корректная формула требует матричного возведения
                
            answer = (answer + add) % MOD
            ones_so_far += 1

    # Проверяем само R
    if int_R.bit_count() % K == 0:
        answer = (answer + 1) % MOD

    print(answer)

if name == "main":
    solve()