import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2].strip()

    # Преобразуем R в двоичную строку
    binary_R = bin(int(R))[2:]
    L = len(binary_R)

    # Если K > L, то подходит только x = 0
    if K > L:
        print(1)
        return

    # Инициализация dp[rem] — количество способов для префикса с остатком rem
    dp = [0] * K
    dp[0] = 1  # пустой префикс

    # Предподсчёт степеней двойки по модулю MOD
    pow2 = [1] * (L + 1)
    for i in range(1, L + 1):
        pow2[i] = (pow2[i - 1] * 2) % MOD

    answer = 0
    for i, bit in enumerate(binary_R):
        new_dp = [0] * K
        rest = L - i - 1  # сколько бит осталось после текущего

        for rem in range(K):
            val = dp[rem]
            if val == 0:
                continue

            if bit == '1':
                # Вариант 1: поставить 0, тогда tight сбрасывается
                # Количество способов для оставшихся rest бит с нужным остатком
                need = (K - rem) % K
                answer = (answer + val * pow2[rest]) % MOD
                # Но это не совсем точно: pow2[rest] — всего чисел, но нам нужно только с остатком need.
                # Неправильно! Нам нужно именно F[rest][need], а не все числа.

                # Вариант 2: поставить 1, остаёмся в tight
                new_rem = (rem + 1) % K
                new_dp[new_rem] = (new_dp[new_rem] + val) % MOD
            else:
                # Только 0
                new_dp[rem] = (new_dp[rem] + val) % MOD

        dp = new_dp

    # Добавляем само число R
    answer = (answer + dp[0]) % MOD
    print(answer)


if __name__ == "__main__":
    solve()