import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    # Преобразуем десятичное число R в двоичную строку
    int_R = int(R)
    binary_R = bin(int_R)[2:]  # строка из '0' и '1'
    L = len(binary_R)

    # Если K > L, то только 0 подходит (popcount(0)=0 делится на любое K)
    if K > L:
        print(1)
        return

    # Динамика F[rest]: количество чисел из rest бит с заданным остатком
    # Инициализируем F[0]
    prev = [0] * K
    prev[0] = 1  # число 0
    F = [prev[:]]  # F[0]

    for rest in range(1, L + 1):
        curr = [0] * K
        for r in range(K):
            curr[r] = (prev[r] + prev[(r - 1) % K]) % MOD
        F.append(curr)
        prev = curr

    # Обход битов числа R
    answer = 0
    ones_so_far = 0  # количество единиц в префиксе
    for i, bit in enumerate(binary_R):
        if bit == '1':
            rest = L - i - 1
            # Нужный остаток: (K - ones_so_far % K) % K
            need_rem = (K - ones_so_far % K) % K
            answer = (answer + F[rest][need_rem]) % MOD
            ones_so_far += 1

    # Учитываем само число R
    if ones_so_far % K == 0:
        answer = (answer + 1) % MOD

    print(answer)


if __name__ == "__main__":
    solve()