import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    # Для больших K решение не укладывается в ограничения по памяти
    if K > 200:
        print(0)
        return

    # Преобразуем десятичное число R в двоичную строку
    int_R = int(R)
    binary_R = bin(int_R)[2:]  # строка из '0' и '1'
    m = len(binary_R)

    # Динамика F[rest][r]: количество чисел из rest бит (от 0 до 2^rest - 1)
    # с popcount дающим остаток r при делении на K
    F = [[0] * K for _ in range(m + 1)]
    F[0][0] = 1
    for rest in range(1, m + 1):
        for r in range(K):
            F[rest][r] = (F[rest - 1][r] + F[rest - 1][(r - 1 + K) % K]) % MOD

    # Обход битов числа R
    answer = 0
    rem = 0  # текущий остаток от количества единиц
    for pos in range(m):
        bit = binary_R[pos]
        if bit == '1':
            rest = m - pos - 1
            need_rem = (K - rem) % K
            answer = (answer + F[rest][need_rem]) % MOD
            rem = (rem + 1) % K
        # если bit == '0', то ничего не меняется

    # Учитываем само число R
    if rem == 0:
        answer = (answer + 1) % MOD

    print(answer)


if __name__ == "__main__":
    solve()