import sys
import math

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    m = int(data[0])
    l, r = int(data[1]), int(data[2])

    # Создаем массив для хранения информации о числах от l до r включительно
    # Для каждого числа храним минимальный простой делитель
    limit = r
    spf = list(range(limit + 1))  # smallest prime factor
    
    # Решето Эратосфена для нахождения наименьших простых делителей
    for i in range(2, int(math.sqrt(limit)) + 1):
        if spf[i] == i:  # i - простое
            for j in range(i * i, limit + 1, i):
                if spf[j] == j:
                    spf[j] = i

    # Функция для проверки, является ли число нечётно-степенным
    def is_odd_power(num):
        if num <= 1:
            return False
        while num > 1:
            p = spf[num]
            cnt = 0
            while num % p == 0:
                num //= p
                cnt += 1
            if cnt % 2 == 0:
                return False
        return True

    # Проверяем числа от l до r
    good = []
    for num in range(l, r + 1):
        good.append(is_odd_power(num))

    # Ищем последовательность из m подряд идущих True
    count = 0
    start = -1
    for i in range(len(good)):
        if good[i]:
            count += 1
            if count == m:
                start = i - m + 1
                break
        else:
            count = 0

    if start == -1:
        print(-1)
    else:
        result = list(range(l + start, l + start + m))
        print(' '.join(map(str, result)))

if __name__ == "__main__":
    main()