import sys

input = sys.stdin.read
data = input().split()

m = int(data[0])
l = int(data[1])
r = int(data[2])

def is_odd_power(n):
    """Проверяет, все ли простые делители в нечётных степенях"""
    if n == 1:
        return True
    
    # Делим на 2 (максимум один раз для нечётной степени)
    if n % 2 == 0:
        n //= 2
        if n % 2 == 0:  # больше одного раза
            return False
    
    # Проверяем нечётные делители
    d = 3
    while d * d <= n:
        count = 0
        while n % d == 0:
            n //= d
            count += 1
        if count % 2 == 0 and count > 0:  # чётная степень
            return False
        d += 2
    
    # Если остался простой делитель > 1, его степень = 1 (нечётная)
    return n <= 1

# Ищем первую последовательность
found = False
for start in range(l, r - m + 2):
    all_odd = True
    for i in range(m):
        if not is_odd_power(start + i):
            all_odd = False
            break
    if all_odd:
        print(' '.join(map(str, range(start, start + m))))
        found = True
        break

if not found:
    print(-1)