import sys

input = sys.stdin.read
data = input().split()

m = int(data[0])
l = int(data[1])
r = int(data[2])

def is_odd_power(n):
    """Проверяет, нечётно-степенное ли число"""
    if n == 1:
        return True
    
    # Делим на 2
    while n % 2 == 0:
        n //= 2
        if n % 2 == 0:
            return False
    
    # Проверяем нечётные делители
    d = 3
    while d * d <= n:
        count = 0
        while n % d == 0:
            n //= d
            count += 1
        if count % 2 == 0:
            return False
        d += 2
    
    if n > 1:
        # Оставшийся делитель в степени 1 (нечётная)
        return True
    
    return True

found = False
for start in range(l, r - m + 2):
    all_odd = True
    for i in range(m):
        if not is_odd_power(start + i):
            all_odd = False
            break
    if all_odd:
        print(' '.join(str(start + i) for i in range(m)))
        found = True
        break

if not found:
    print(-1)