import sys

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    # Проверяем, что m не превышает длину отрезка
    if m > r - l + 1:
        print(-1)
        return
    
    # 1. Решето для нахождения наименьшего простого делителя
    N = r
    spf = list(range(N + 1))  # spf[i] = i для простых чисел
    
    # Модифицированное решето Эратосфена
    for i in range(2, int(N**0.5) + 1):
        if spf[i] == i:  # i простое
            for j in range(i * i, N + 1, i):
                if spf[j] == j:  # если ещё не нашли меньший делитель
                    spf[j] = i
    
    # 2. Определение, является ли число нечётно-степенным
    is_odd_powerful = [False] * (N + 1)
    is_odd_powerful[1] = True  # 1 - нечётно-степенное (нет простых делителей)
    
    for n in range(2, N + 1):
        p = spf[n]  # наименьший простой делитель
        cnt = 0
        temp = n
        # Считаем степень p в разложении n
        while temp % p == 0:
            temp //= p
            cnt += 1
        # Если степень чётная или оставшаяся часть не нечётно-степенная
        if cnt % 2 == 0:
            is_odd_powerful[n] = False
        else:
            is_odd_powerful[n] = is_odd_powerful[temp]
    
    # 3. Поиск последовательности длины m на отрезке [l, r]
    current_len = 0
    start = -1
    
    for x in range(l, r + 1):
        if is_odd_powerful[x]:
            current_len += 1
            if current_len == m:
                start = x - m + 1
                break
        else:
            current_len = 0
    
    # 4. Вывод результата
    if start == -1:
        print(-1)
    else:
        result = ' '.join(str(start + i) for i in range(m))
        print(result)

if name == "__main__":
    solve()