import sys
import math

def solve() -> None:
    data = sys.stdin.read().strip().split()
    if not data:
        return
        
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    if m > r - l + 1:
        print(-1)
        return
    
    # Максимальное значение до которого будем работать
    max_val = r
    
    # Решето Эратосфена для нахождения минимального простого делителя
    spf = list(range(max_val + 1))  # smallest prime factor
    spf[0] = spf[1] = 1
    
    for i in range(2, int(math.isqrt(max_val)) + 1):
        if spf[i] == i:  # i простое
            for j in range(i * i, max_val + 1, i):
                if spf[j] == j:  # ещё не нашли делитель
                    spf[j] = i
    
    # Массив для проверки, является ли число нечётно-степенным
    is_odd_power = [True] * (max_val + 1)
    is_odd_power[0] = False  # 0 не натуральное
    is_odd_power[1] = True   # 1 - пустое произведение, считается подходящим
    
    for num in range(2, max_val + 1):
        if is_odd_power[num] is None:
            continue
        
        n = num
        temp_num = num
        # Факторизуем текущее число
        factor_counts = {}
        while temp_num > 1:
            p = spf[temp_num]
            cnt = 0
            while temp_num % p == 0:
                temp_num //= p
                cnt += 1
            factor_counts[p] = cnt
            
            # Проверяем степень текущего простого
            if cnt % 2 == 0:  # степень чётная - не подходит
                # Помечаем все числа, делящиеся на p^cnt
                power = p
                for _ in range(cnt):
                    power *= p
                # На самом деле нам нужно отметить само число
                is_odd_power[num] = False
                break
        
        if num not in factor_counts:  # число простое
            is_odd_power[num] = True
        elif not is_odd_power[num]:
            continue  # уже пометили как неподходящее
        else:
            # Проверили все простые делители
            is_odd_power[num] = True
    
    # Поиск последовательности длины m
    count = 0
    start = -1
    
    for i in range(l, r + 1):
        if is_odd_power[i]:
            count += 1
            if count == m:
                start = i - m + 1
                break
        else:
            count = 0
    
    if start == -1:
        print(-1)
    else:
        result = list(range(start, start + m))
        print(' '.join(map(str, result)))

if __name__ == "__main__":
    solve()