def count_in_range_mod3(l, r, residue):
    # количество целых x в [l, r] с x ≡ residue (mod 3)
    # residue: 0,1,2
    # первая подходящая
    first = l + ((residue - l) % 3)
    if first > r:
        return 0
    return (r - first) // 3 + 1


def solve():
    import sys
    data = sys.stdin.read().strip().split()
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])  # 1..5, но у нас цвета только 1..3

    # если k > 3, в прямоугольнике вообще нет таких цветов
    if k > 3:
        print(0)
        return

    # диапазон по i (ось x)
    L = -n
    R = n

    # столбцы по j: от -m до m
    # нечётные j: j % 2 != 0
    # чётные j: j % 2 == 0
    # легко заметить (проверка по маленьким m), что:
    odd_cols = m + 1     # количество нечётных j
    even_cols = m        # количество чётных j

    # для нечётных j цвет задаётся формулой: c = (i mod 3) + 1
    # значит i ≡ (k-1) (mod 3)
    need_res_odd = (k - 1) % 3
    cnt_i_odd = count_in_range_mod3(L, R, need_res_odd)

    # для чётных j: c = ((i + 2) mod 3) + 1 => (i + 2) ≡ k-1 (mod 3)
    # i ≡ (k-3) (mod 3)
    need_res_even = (k - 3) % 3
    cnt_i_even = count_in_range_mod3(L, R, need_res_even)

    ans = cnt_i_odd * odd_cols + cnt_i_even * even_cols
    print(ans)


if name == "main":
    solve()