python
import sys

def solve() -> None:
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])

    # Количество строк и столбцов после сдвига к нулевым индексам
    N = n
    M = m

    # cntX[a] – количество строк i' с остатком a по модулю k
    cntX = [0] * k
    qx = N // k
    rx = N % k
    for a in range(k):
        cntX[a] = qx + (1 if a < rx else 0)

    # cntY[b] – количество столбцов j' с остатком b по модулю k
    cntY = [0] * k
    qy = M // k
    ry = M % k
    for b in range(k):
        cntY[b] = qy + (1 if b < ry else 0)

    answers = []
    for color in range(1, k + 1):
        r = color - 1  # остаток, соответствующий этому цвету
        total = 0
        for a in range(k):
            b = (r - a) % k
            total += cntX[a] * cntY[b]
        answers.append(total)

    sys.stdout.write("\n".join(map(str, answers)))

if __name__ == "__main__":
    solve()