def count_magic_numbers(n):
    """Количество магических чисел, не превышающих n."""
    if n < 7:
        return 0
    # Формула включения-исключения
    return n // 7 + (n + 3) // 10 - (n - 7) // 70 - 1

def find_kth_magic_number(k):
    """Находит k-е магическое число с помощью бинарного поиска."""
    left, right = 1, 10**19  # Правая граница достаточно большая
    while left < right:
        mid = (left + right) // 2
        if count_magic_numbers(mid) < k:
            left = mid + 1
        else:
            right = mid
    return left

# Основная программа
k = int(input())
print(find_kth_magic_number(k))