def count_magic(n: int) -> int:
    """
    Возвращает количество магических чисел от 1 до n включительно.
    Магическое число: делится на 7 ИЛИ оканчивается на 7.
    """
    # Числа, делящиеся на 7
    div_by_7 = n // 7
    # Числа, оканчивающиеся на 7
    ends_with_7 = (n + 3) // 10
    # Числа, одновременно делящиеся на 7 и оканчивающиеся на 7
    both = (n + 63) // 70
    
    # По принципу включения-исключения
    return div_by_7 + ends_with_7 - both


def find_kth_magic(k: int) -> int:
    """
    Находит k-е магическое число с помощью бинарного поиска.
    """
    left, right = 1, 7 * k  # 7*k - гарантированно магическое
    
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
    
    return left


def main():
    k = int(input().strip())
    result = find_kth_magic(k)
    print(result)


if __name__ == "__main__":
    main()