import sys

def first_in_range(L, R, r, k):
    """Найти наименьшее x >= L такое, что x % k == r. Если нет, вернуть None."""
    if k == 1:                     # любое число имеет остаток 0 при делении на 1
        return L if L <= R else None
    mod_L = L % k
    diff = (r - mod_L) % k
    x = L + diff
    return x if x <= R else None

def sum_arithmetic(L, R, r, k):
    """Возвращает (count, sum_s) для s в [L,R] с s%k==r."""
    x0 = first_in_range(L, R, r, k)
    if x0 is None:
        return (0, 0)
    count = (R - x0) // k + 1
    last = x0 + (count - 1) * k
    sum_s = count * (x0 + last) // 2
    return (count, sum_s)

def solve_one(n, m, k):
    a = min(n, m)
    b = max(n, m)
    L1, R1 = 2, a + 1
    L2, R2 = a + 2, b + 1
    L3, R3 = b + 2, n + m
    results = []
    for c in range(1, k + 1):
        r = (c + 1) % k           # остаток, который должен иметь s
        total = 0
        # Интервал I: L(s) = s-1
        cnt1, sum_s1 = sum_arithmetic(L1, R1, r, k)
        if cnt1 > 0:
            total += sum_s1 - cnt1
        # Интервал II: L(s) = a
        if L2 <= R2:
            cnt2, _ = sum_arithmetic(L2, R2, r, k)
            if cnt2 > 0:
                total += a * cnt2
        # Интервал III: L(s) = n+m+1 - s
        if L3 <= R3:
            cnt3, sum_s3 = sum_arithmetic(L3, R3, r, k)
            if cnt3 > 0:
                total += (n + m + 1) * cnt3 - sum_s3
        results.append(total)
    return results

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    nums = list(map(int, data))
    idx = 0
    out_lines = []
    while idx < len(nums):
        n = nums[idx]
        m = nums[idx + 1]
        k = nums[idx + 2]
        idx += 3
        res = solve_one(n, m, k)
        out_lines.extend(res)
    sys.stdout.write("\n".join(map(str, out_lines)) + "\n")

if __name__ == "__main__":
    solve()