import sys

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])

    # Количество строк и столбцов с каждым остатком по модулю k
    A = [0] * k  # для строк
    B = [0] * k  # для столбцов

    qn, rn = divmod(n, k)
    qm, rm = divmod(m, k)

    for rem in range(k):
        if rem == 0:
            A[rem] = qn
            B[rem] = qm
        else:
            A[rem] = qn + (1 if rem <= rn else 0)
            B[rem] = qm + (1 if rem <= rm else 0)

    # Подсчёт количества клеток для каждого остатка суммы координат
    cnt = [0] * k
    for r in range(k):
        for a in range(k):
            b = (r - a) % k
            cnt[r] += A[a] * B[b]

    # Сопоставление остатков с цветами
    out_lines = []
    for color in range(1, k + 1):
        rem = (color + 1) % k
        out_lines.append(str(cnt[rem]))
    sys.stdout.write("\n".join(out_lines))

if name == "main":
    main()