def intersects_rect(x1, y1, x2, y2, a, b, c):
    corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
    signs = [a * x + b * y + c for x, y in corners]
    min_sign = min(signs)
    max_sign = max(signs)
    return min_sign <= 0 <= max_sign


def solve_case(rects):
    n = len(rects)

    if n == 1:
        return True

    if n == 2:
        return True

    points = []
    for x1, y1, x2, y2 in rects:
        points.extend([(x1, y1), (x1, y2), (x2, y1), (x2, y2)])

    for i in range(len(points)):
        for j in range(i + 1, len(points)):
            px1, py1 = points[i]
            px2, py2 = points[j]

            if px1 == px2 and py1 == py2:
                continue

            a = py2 - py1
            b = px1 - px2
            c = px2 * py1 - px1 * py2

            all_intersect = True
            for rect in rects:
                if not intersects_rect(rect[0], rect[1], rect[2], rect[3], a, b, c):
                    all_intersect = False
                    break

            if all_intersect:
                return True

    return False


T = int(input())
for _ in range(T):
    n = int(input())
    rects = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rects.append((x1, y1, x2, y2))

    if solve_case(rects):
        print("Yes")
    else:
        print("No")
