import sys

sys.set_int_max_str_digits(100000)

n, K = map(int, input().split())
R_str = input().strip()

MOD = 10 ** 9 + 7

if R_str == "0":
    print(1)
    sys.exit()

R = int(R_str)
binary_R = bin(R)[2:]
n_bits = len(binary_R)

dp_tight = {0: 1}
dp_loose = {}

for i in range(n_bits):
    bit = int(binary_R[i])

    new_tight = {}
    new_loose = {}

    for mod, count in dp_loose.items():
        new_loose[mod] = (new_loose.get(mod, 0) + count) % MOD
        new_mod = (mod + 1) % K
        new_loose[new_mod] = (new_loose.get(new_mod, 0) + count) % MOD

    for mod, count in dp_tight.items():
        if bit == 0:
            new_tight[mod] = (new_tight.get(mod, 0) + count) % MOD
        else:
            new_loose[mod] = (new_loose.get(mod, 0) + count) % MOD
            new_mod = (mod + 1) % K
            new_tight[new_mod] = (new_tight.get(new_mod, 0) + count) % MOD

    dp_tight = new_tight
    dp_loose = new_loose

result = (dp_tight.get(0, 0) + dp_loose.get(0, 0)) % MOD
print(result)
