def sieve_odd_power(max_n):
    min_prime = list(range(max_n + 1))

    for i in range(2, int(max_n ** 0.5) + 1):
        if min_prime[i] == i:
            for j in range(i * i, max_n + 1, i):
                if min_prime[j] == j:
                    min_prime[j] = i

    is_odd = [False] * (max_n + 1)
    is_odd[1] = True

    for i in range(2, max_n + 1):
        if min_prime[i] == i:
            is_odd[i] = True
        else:
            p = min_prime[i]
            temp = i
            power = 0
            while temp % p == 0:
                power += 1
                temp //= p
            is_odd[i] = (power % 2 == 1) and is_odd[temp]

    return is_odd


m = int(input())
l, r = map(int, input().split())

is_odd = sieve_odd_power(r)

consecutive = 0
for i in range(l, r + 1):
    if is_odd[i]:
        consecutive += 1
        if consecutive >= m:
            start = i - m + 1
            print(' '.join(map(str, range(start, start + m))))
            exit()
    else:
        consecutive = 0

print(-1)

