def first_in_range(c, start, k):
    if c >= start:
        return c
    return c + ((start - c + k - 1) // k) * k


def count_in_range_fixed(c, start, end, k):
    if start > end:
        return 0
    first = first_in_range(c, start, k)
    if first > end:
        return 0
    return (end - first) // k + 1


def sum_arithmetic(first, step, count):
    if count == 0:
        return 0
    return count * first + step * count * (count - 1) // 2


n = int(input())
m = int(input())
k = int(input())

colors = [0] * k
total_diags = n + m - 1
min_nm = min(n, m)
max_nm = max(n, m)

for c in range(k):
    if c >= total_diags:
        continue

    zone1_end = min_nm - 1
    cnt1 = count_in_range_fixed(c, 0, zone1_end, k)
    if cnt1 > 0:
        first_diag = first_in_range(c, 0, k)
        colors[c] += sum_arithmetic(first_diag + 1, k, cnt1)

    zone2_start = min_nm
    zone2_end = max_nm - 1
    cnt2 = count_in_range_fixed(c, zone2_start, zone2_end, k)
    if cnt2 > 0:
        colors[c] += cnt2 * min_nm

    zone3_start = max_nm
    zone3_end = total_diags - 1
    cnt3 = count_in_range_fixed(c, zone3_start, zone3_end, k)
    if cnt3 > 0:
        first_diag = first_in_range(c, zone3_start, k)
        first_value = total_diags - first_diag
        colors[c] += sum_arithmetic(first_value, -k, cnt3)

for count in colors:
    print(count)
