import sys
sys.setrecursionlimit(10**7)

MOD = 10**9 + 7

# Читаем входные данные
n, K = map(int, input().split())
R_str = input().strip()

# Переводим R в двоичную запись
R_bin = bin(int(R_str))[2:]

length = len(R_bin)

# Инициализируем мемоизацию: [pos][rem][less]
# rem — остаток по модулю K от popcount
# less — 0 или 1
from functools import lru_cache

@lru_cache(None)
def dp(pos, rem, less):
    # База: если дошли до конца
    if pos == length:
        # Проверям popcount ≡ 0 (mod K)
        return 1 if rem == 0 else 0
    
    limit_bit = int(R_bin[pos]) if not less else 1
    result = 0
    for bit in range(limit_bit + 1):
        new_less = less
        if not less and bit < limit_bit:
            new_less = True
        new_rem = rem
        if bit == 1:
            new_rem = (new_rem + 1) % K
        result += dp(pos + 1, new_rem, new_less)
        result %= MOD
    return result

answer = dp(0, 0, False)
print(answer)