import sys

# Чтение входных данных
m = int(sys.stdin.readline())
l, r = map(int, sys.stdin.readline().split())

max_n = r

# 1. Находим smallest_prime_factor для чисел до r
spf = [0] * (max_n + 1)
def sieve_spf():
    spf[1] = 1
    for i in range(2, max_n+1):
        if spf[i] == 0:
            spf[i] = i
            for j in range(i*i, max_n+1, i):
                if spf[j] == 0:
                    spf[j] = i

sieve_spf()

# 2. для каждого числа определим, является ли оно "нечётно-степенным"
is_odd_exponent = [False] * (max_n + 1)
is_odd_exponent[1] = True  # 1 — (технически) нечётные степени (пустое разложение)

for num in range(2, max_n + 1):
    count_exponents = {}
    temp = num
    # разлагаем число
    while temp > 1:
        p = spf[temp]
        count_exponents[p] = count_exponents.get(p, 0) + 1
        temp //= p
    # проверяем, все ли показатели нечётные
    if all(exp % 2 == 1 for exp in count_exponents.values()):
        is_odd_exponent[num] = True

# 3. ищем последовательность из m подряд "нечётно-степенных" чисел
result_sequence = []
for num in range(l, r+1):
    if is_odd_exponent[num]:
        result_sequence.append(num)
        if len(result_sequence) == m:
            break
    else:
        result_sequence = []
        
if len(result_sequence) == m:
    print(" ".join(map(str, result_sequence)))
else:
    print(-1)