def main():
    MOD = 10 ** 9 + 7
    n, K = map(int, input().split())
    R = input().strip()

    if K == 1:
        print(int(R) % MOD)
        return

    digits = list(map(int, R))

    from functools import lru_cache

    @lru_cache(maxsize=None)
    def dp(pos, cnt, tight):
        if pos == n:
            return 1 if cnt % K == 0 else 0

        limit = digits[pos] if tight else 9
        total = 0

        for d in range(limit + 1):
            new_tight = tight and (d == limit)
            new_cnt = cnt + (1 if d == 1 else 0)
            total = (total + dp(pos + 1, new_cnt, new_tight)) % MOD

        return total

    result = dp(0, 0, True)
    print(result)


if __name__ == "__main__":
    main()
