def is_odd_power_number(n):
    if n == 1:
        return True
    d = 2
    while d * d <= n:
        cnt = 0
        while n % d == 0:
            cnt += 1
            n //= d
        if cnt > 0 and cnt % 2 == 0:
            return False
        d += 1
    return True

# Чтение входных данных
m = int(input())  # длина последовательности
l, r = map(int, input().split())  # границы отрезка [l; r]

# Предвычисляем, какие числа в диапазоне [l, r] являются нечётно-степенными
is_odd = []
for num in range(l, r + 1):
    is_odd.append(is_odd_power_number(num))

# Ищем первую последовательность из m подряд идущих нечётно-степенных чисел
result = -1
for start_idx in range(len(is_odd) - m + 1):
    # Проверяем, все ли m чисел начиная с start_idx — нечётно-степенные
    if all(is_odd[start_idx:start_idx + m]):
        # Находим начальное число в исходной нумерации
        first_num = l + start_idx
        result = list(range(first_num, first_num + m))
        break

# Вывод результата
if result == -1:
    print(-1)
else:
    print(' '.join(map(str, result)))
