import sys

def can_shoot_beam(rectangles):
    if len(rectangles) == 1:
        return "Yes"  # Одна комната — всегда есть луч

    # Множества для хранения возможных 'c' для каждого типа прямых
    horiz = set()    # y = c
    vert = set()     # x = c
    slope_45 = set() # y = x + c -> c = y - x
    slope_135 = set() # y = -x + c -> c = y + x

    for x1, y1, x2, y2 in rectangles:
        # Горизонтальные прямые (верх и низ комнаты)
        horiz.add(y1)
        horiz.add(y2)
        # Вертикальные прямые (лево и право комнаты)
        vert.add(x1)
        vert.add(x2)
        # Прямые под углом 45° (из 4 углов комнаты)
        slope_45.add(y1 - x1)
        slope_45.add(y2 - x2)
        slope_45.add(y1 - x2)
        slope_45.add(y2 - x1)
        # Прямые под углом 135° (из 4 углов комнаты)
        slope_135.add(y1 + x1)
        slope_135.add(y2 + x2)
        slope_135.add(y1 + x2)
        slope_135.add(y2 + x1)

    # Проверяем, есть ли общая прямая для всех комнат
    if len(horiz) == 1:
        return "Yes"  # Все комнаты на одном уровне y
    if len(vert) == 1:
        return "Yes"  # Все комнаты на одном уровне x
    if len(slope_45) == 1:
        return "Yes"  # Все комнаты пересекаются одной прямой 45°
    if len(slope_135) == 1:
        return "Yes"  # Все комнаты пересекаются одной прямой 135°

    return "No"  # Ни один тип прямых не подходит

def main():
    input_lines = sys.stdin.read().splitlines()  # Читаем все строки сразу
    idx = 0
    T = int(input_lines[idx])  # Количество наборов
    idx += 1
    results = []

    for _ in range(T):  # Проходим по каждому набору
        n = int(input_lines[idx])  # Число комнат в этом наборе
        idx += 1
        rectangles = []
        for _ in range(n):  # Считываем ровно n строк с координатами
            x1, y1, x2, y2 = map(int, input_lines[idx].split())
            rectangles.append((x1, y1, x2, y2))
            idx += 1
        results.append(can_shoot_beam(rectangles))  # Обрабатываем набор

    for result in results:
        print(result)  # Выводим результаты для всех наборов

if __name__ == "__main__":
    main()
