import sys

def can_shoot_beam(rectangles):
    if len(rectangles) == 1:
        return "Yes"  


    horiz = set()    # y = c
    vert = set()     # x = c
    slope_45 = set() # y = x + c -> c = y - x
    slope_135 = set() # y = -x + c -> c = y + x

    for x1, y1, x2, y2 in rectangles:

        horiz.add(y1)
        horiz.add(y2)

        vert.add(x1)
        vert.add(x2)

        slope_45.add(y1 - x1)
        slope_45.add(y2 - x2)
        slope_45.add(y1 - x2)
        slope_45.add(y2 - x1)

        slope_135.add(y1 + x1)
        slope_135.add(y2 + x2)
        slope_135.add(y1 + x2)
        slope_135.add(y2 + x1)


    if len(horiz) == 1:
        return "Yes"
    if len(vert) == 1:
        return "Yes"
    if len(slope_45) == 1:
        return "Yes"
    if len(slope_135) == 1:
        return "Yes"

    return "No"

def main():
    input_lines = sys.stdin.read().splitlines()
    idx = 0
    T = int(input_lines[idx])
    idx += 1
    results = []

    for _ in range(T):
        n = int(input_lines[idx])
        idx += 1
        rectangles = []
        for _ in range(n):
            x1, y1, x2, y2 = map(int, input_lines[idx].split())
            rectangles.append((x1, y1, x2, y2))
            idx += 1
        results.append(can_shoot_beam(rectangles))

    for result in results:
        print(result)

if __name__ == "__main__":
    main()
