import sys

def can_shoot_beam(rectangles):
    if len(rectangles) == 1:
        return "Yes"


    all_points = []
    for x1, y1, x2, y2 in rectangles:
        all_points.extend([(x1, y1), (x1, y2), (x2, y1), (x2, y2)])


    all_y = [y for _, y in all_points]
    all_x = [x for x, _ in all_points]

    if len(set(all_y)) == 1:
        return "Yes"
    if len(set(all_x)) == 1:
        return "Yes"


    # Для 45°: y = x + c
    diffs_45 = [y - x for x, y in all_points]
    if len(set(diffs_45)) == 1:
        return "Yes"

    # Для 135°: y = -x + c
    diffs_135 = [y + x for x, y in all_points]
    if len(set(diffs_135)) == 1:
        return "Yes"

    return "No"

def main():
    input = sys.stdin.read().splitlines()
    idx = 0
    T = int(input[idx])
    idx += 1
    results = []

    for _ in range(T):
        n = int(input[idx])
        idx += 1
        rectangles = []
        for _ in range(n):
            x1, y1, x2, y2 = map(int, input[idx].split())
            rectangles.append((x1, y1, x2, y2))
            idx += 1
        results.append(can_shoot_beam(rectangles))

    for result in results:
        print(result)

if __name__ == "__main__":
    main()
