def intersect_intervals(intervals):
    low = -float('inf')
    high = float('inf')
    for l, h in intervals:
        low = max(low, l)
        high = min(high, h)
        if low > high:
            return None
    return (low, high)


def solve_one(n, rects):
    # Проверка горизонтальной прямой
    y_low = max(y1 for x1, y1, x2, y2 in rects)
    y_high = min(y2 for x1, y1, x2, y2 in rects)
    if y_low <= y_high:
        return True

    # Проверка вертикальной прямой
    x_low = max(x1 for x1, y1, x2, y2 in rects)
    x_high = min(x2 for x1, y1, x2, y2 in rects)
    if x_low <= x_high:
        return True

    # Собираем все вершины
    vertices = []
    for x1, y1, x2, y2 in rects:
        vertices.append((x1, y1))
        vertices.append((x1, y2))
        vertices.append((x2, y1))
        vertices.append((x2, y2))

    # Перебираем пары вершин (разных или одинаковых) как направляющие для прямой
    # Но если вершины совпадают, это точка, прямая через точку может иметь любой наклон
    # Поэтому достаточно перебрать все пары различных вершин
    for i in range(len(vertices)):
        for j in range(i + 1, len(vertices)):
            xa, ya = vertices[i]
            xb, yb = vertices[j]
            if xa == xb and ya == yb:
                continue
            # Прямая через (xa, ya) и (xb, yb)
            if xa == xb:
                # вертикальная уже проверена
                continue
            k = (yb - ya) / (xb - xa)
            b = ya - k * xa
            # Проверяем, пересекает ли прямая y = kx + b каждый прямоугольник
            ok = True
            for x1, y1, x2, y2 in rects:
                # Находим min и max y на прямой в пределах x in [x1, x2]
                y_at_x1 = k * x1 + b
                y_at_x2 = k * x2 + b
                y_min_seg = min(y_at_x1, y_at_x2)
                y_max_seg = max(y_at_x1, y_at_x2)
                if y_max_seg < y1 - 1e-12 or y_min_seg > y2 + 1e-12:
                    ok = False
                    break
            if ok:
                return True
    return False


def main():
    import sys
    input = sys.stdin.read
    data = input().split()
    t = int(data[0])
    idx = 1
    results = []
    for _ in range(t):
        n = int(data[idx]);
        idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]);
            y1 = int(data[idx + 1]);
            x2 = int(data[idx + 2]);
            y2 = int(data[idx + 3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        if solve_one(n, rects):
            results.append("Yes")
        else:
            results.append("No")
    print("\n".join(results))


if __name__ == "__main__":
    main()