import math

def sieve_spf(n):
    spf = list(range(n + 1))
    for i in range(2, int(math.isqrt(n)) + 1):
        if spf[i] == i:
            for j in range(i * i, n + 1, i):
                if spf[j] == j:
                    spf[j] = i
    return spf

def is_odd_power(n, spf):
    if n == 1:
        return True
    while n > 1:
        p = spf[n]
        cnt = 0
        while n % p == 0:
            n //= p
            cnt += 1
        if cnt % 2 == 0:
            return False
    return True

m = int(input())
l, r = map(int, input().split())

MAX = 10**6
spf = sieve_spf(MAX)
is_odd_power_arr = [is_odd_power(i, spf) for i in range(MAX + 1)]

count = 0
start = -1
for i in range(l, r + 1):
    if is_odd_power_arr[i]:
        count += 1
        if count == m:
            start = i - m + 1
            break
    else:
        count = 0

if start == -1:
    print(-1)
else:
    print(' '.join(map(str, range(start, start + m))))
